﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<ItineraryCommentsViewModel>" %>
<div class="panel comments">
    <div class="innerPanel">
        <h2><span>Comments</span></h2>
        <div class="items">
            <% if (Model.Comments.Count() == 0) %>
            <% { %>
                <p>The are no comments for this item.</p>
                <p>Be the first to write one!</p>
            <% }  else { %>
                <ul>
                <li><p><a href="#commentForm" onclick="$('div.comments div.items').scrollTop($('#commentForm').position().top); return false">Leave a comment</a></p></li>
                <% foreach (var comment in Model.Comments) %> 
                <% { %>
                    <li>
                        <p>
                            On <%:comment.Timestamp.ToLongDateString()%> by <strong><%:comment.DisplayName%></strong><br />
                            <span><%:comment.Body%></span>
                        </p>
                    </li>
                <% } %>
                </ul>
            <% } %>
            <div id="commentForm">
                <h3><label for="comment">Leave a comment</label></h3>
                <% if(Request.IsAuthenticated) %>
                <% { %>
                    <% using (Html.BeginForm<ItinerariesController>(c => c.AddComment(Model.ItineraryId, null), FormMethod.Post)) %>
                    <% { %>
                        <%=Html.AntiForgeryToken()%>
                        <p><textarea name="comment" id="comment" rows="3" cols="30"></textarea></p>
                        <div class="submit">
                            <input type="submit" value="Add Comment" />
                        </div>
                    <% } %>
                <% } else { %>
                    <p><em>Please Sign In to leave a comment</em></p>
                <% } %>
            </div>
        </div>
        <div class="toolbox"></div>
    </div>
</div>